import { Vendor, OnboardingRequest } from '@/types';
/**
 * Vendor Service - Handles vendor-related database operations
 */
export declare class VendorService {
    /**
     * Create a new vendor record
     */
    createVendor(vendorData: {
        user_id: string;
        email: string;
        business_name: string | null;
        onboarding_status: string;
        subscription_plan: string;
    }): Promise<{
        data: any;
        error: import("@supabase/postgrest-js").PostgrestError | null;
    } | {
        data: null;
        error: unknown;
    }>;
    /**
     * Get vendor by user ID
     */
    getVendorByUserId(userId: string): Promise<{
        data: any;
        error: import("@supabase/postgrest-js").PostgrestError | null;
    } | {
        data: null;
        error: unknown;
    }>;
    /**
     * Get vendor by ID
     */
    getVendorById(vendorId: string): Promise<{
        data: any;
        error: import("@supabase/postgrest-js").PostgrestError | null;
    } | {
        data: null;
        error: unknown;
    }>;
    /**
     * Update vendor onboarding information
     */
    updateOnboarding(vendorId: string, onboardingData: OnboardingRequest): Promise<{
        data: any;
        error: import("@supabase/postgrest-js").PostgrestError | null;
    } | {
        data: null;
        error: unknown;
    }>;
    /**
     * Update vendor profile
     */
    updateVendor(vendorId: string, updateData: Partial<Vendor>): Promise<{
        data: any;
        error: import("@supabase/postgrest-js").PostgrestError | null;
    } | {
        data: null;
        error: unknown;
    }>;
    /**
     * Get all vendors (admin only)
     */
    getAllVendors(): Promise<{
        data: any[] | null;
        error: import("@supabase/postgrest-js").PostgrestError | null;
    } | {
        data: null;
        error: unknown;
    }>;
    /**
     * Delete vendor (admin only)
     */
    deleteVendor(vendorId: string): Promise<{
        error: unknown;
    }>;
}
export declare const vendorService: VendorService;
//# sourceMappingURL=service.d.ts.map